@extends('layouts.app')

@section('content')
    <!-- Hero Section -->
    <div class="relative h-64 sm:h-80 md:h-96 bg-gray-900">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-cover bg-center bg-no-repeat"
            style="background-image: url('https://images.unsplash.com/photo-1551601651-2a8555f1a136?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80');">
            <div class="absolute inset-0 bg-black bg-opacity-40"></div>
        </div>

        <!-- Breadcrumb -->
        <div class="relative z-10 pt-8">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <nav class="text-white text-sm">
                    <span class="text-white">HOME</span>
                    <span class="mx-2">•</span>
                    <span class="text-white">REGISTRASI</span>
                </nav>
            </div>
        </div>

        <!-- Main Title -->
        <div class="absolute inset-0 flex items-end justify-center pb-16 sm:pb-24 md:pb-48">
            <div class="text-center px-4">
                <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-6xl font-bold text-white uppercase tracking-wide">
                    KLINIK ZEN JOGJA
                </h1>
            </div>
        </div>
    </div>

    <!-- Main Content Section -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">
                <!-- Left Column - Registration Information -->
                <div>
                    <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Informasi Pendaftaran</h2>
                    <div class="space-y-4 mb-8">
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">1</span>
                            <p class="text-gray-700">Pasien mengisi form ini dengan data yang sesuai dengan data diri
                                sebenarnya</p>
                        </div>
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">2</span>
                            <p class="text-gray-700">Pada kolom pemeriksaan pasien wajib mengisi semua jenis pemeriksaan
                                yang dibutuhkan</p>
                        </div>
                    </div>

                    <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-4">SYARAT DAN KETENTUAN:</h3>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">1</span>
                            <p class="text-gray-700">Registrasi online dilakukan H-1 sebelum pelaksanaan test.</p>
                        </div>
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">2</span>
                            <div class="text-gray-700">
                                <p class="mb-2">Jadwal registrasi online:</p>
                                <ul class="ml-4 space-y-1">
                                    <li>• Pukul 07:00 WIB – 17:00 WIB (untuk pelaksanaan test H+1)</li>
                                    <li>• Setelah pukul 17:00 WIB (untuk pelaksanaan test H+2 dst (menyesuaikan jadwal yang
                                        ada))</li>
                                </ul>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">3</span>
                            <p class="text-gray-700">Order test dinyatakan valid setelah dikonfirmasi oleh petugas kami baik
                                melalui WA maupun secara langsung</p>
                        </div>
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">4</span>
                            <p class="text-gray-700">Order test berlaku untuk pelanggan sesuai nama yang diinputkan di form
                                ini (tidak dapat dipindahtangankan).</p>
                        </div>
                        <div class="flex items-start">
                            <span
                                class="flex-shrink-0 w-8 h-8 bg-[#192D50] text-white rounded-full flex items-center justify-center text-sm font-semibold mr-4">5</span>
                            <p class="text-gray-700">Pembayaran dapat ditransfer ke rekening atas nama Klinik Zen Jogja</p>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Registration Form -->
                <div>
                    <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Masukkan data diri kamu</h2>
                    <form action="{{ route('registration.store') }}" method="POST" enctype="multipart/form-data"
                        class="space-y-6">
                        @csrf
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Nama Sesuai KTP
                                *</label>
                            <input type="text" id="name" name="name" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('name') }}">
                            @error('name')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="identity_card_type" class="block text-sm font-medium text-gray-700 mb-2">Jenis Kartu
                                Identitas (pilih salah satu) *</label>
                            <select id="identity_card_type" name="identity_card_type" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                                <option value="">Pilih jenis kartu identitas</option>
                                <option value="KTP" {{ old('identity_card_type') == 'KTP' ? 'selected' : '' }}>KTP
                                </option>
                                <option value="KITAS" {{ old('identity_card_type') == 'KITAS' ? 'selected' : '' }}>KITAS
                                </option>
                                <option value="Passport" {{ old('identity_card_type') == 'Passport' ? 'selected' : '' }}>
                                    Passport</option>
                            </select>
                            @error('identity_card_type')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="ktp_number" class="block text-sm font-medium text-gray-700 mb-2">Nomor Kartu
                                Identitas *</label>
                            <input type="text" id="ktp_number" name="ktp_number" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('ktp_number') }}">
                            @error('ktp_number')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="birth_place" class="block text-sm font-medium text-gray-700 mb-2">Tempat Kelahiran
                                *</label>
                            <input type="text" id="birth_place" name="birth_place" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('birth_place') }}">
                            @error('birth_place')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="birth_date" class="block text-sm font-medium text-gray-700 mb-2">Tanggal Lahir
                                *</label>
                            <input type="date" id="birth_date" name="birth_date" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                value="{{ old('birth_date') }}">
                            @error('birth_date')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="gender" class="block text-sm font-medium text-gray-700 mb-2">Jenis Kelamin
                                *</label>
                            <select id="gender" name="gender" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                                <option value="">Pilih jenis kelamin</option>
                                <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Laki-laki</option>
                                <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Perempuan
                                </option>
                            </select>
                            @error('gender')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="marital_status"
                                class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                            <select id="marital_status" name="marital_status"
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                                <option value="">Pilih status</option>
                                <option value="single" {{ old('marital_status') == 'single' ? 'selected' : '' }}>Belum
                                    Menikah</option>
                                <option value="married" {{ old('marital_status') == 'married' ? 'selected' : '' }}>Menikah
                                </option>
                                <option value="divorced" {{ old('marital_status') == 'divorced' ? 'selected' : '' }}>Cerai
                                </option>
                                <option value="widowed" {{ old('marital_status') == 'widowed' ? 'selected' : '' }}>
                                    Janda/Duda</option>
                            </select>
                            @error('marital_status')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="address" class="block text-sm font-medium text-gray-700 mb-2">Alamat sesuai KTP
                                *</label>
                            <textarea id="address" name="address" rows="3" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="">{{ old('address') }}</textarea>
                            @error('address')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email *</label>
                            <input type="email" id="email" name="email" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('email') }}">
                            @error('email')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">No Hp/Whatsapp
                                *</label>
                            <input type="tel" id="phone" name="phone" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('phone') }}">
                            @error('phone')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="exam_date" class="block text-sm font-medium text-gray-700 mb-2">Tanggal Kunjungan
                                *</label>
                            <input type="date" id="exam_date" name="exam_date" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                value="{{ old('exam_date') }}">
                            @error('exam_date')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="exam_type" class="block text-sm font-medium text-gray-700 mb-2">Layanan *</label>
                            <input type="text" id="exam_type" name="exam_type" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="" value="{{ old('exam_type') }}">
                            @error('exam_type')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="notes"
                                class="block text-sm font-medium text-gray-700 mb-2">Catatan/keluhan</label>
                            <textarea id="notes" name="notes" rows="3"
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 resize"
                                placeholder="">{{ old('notes') }}</textarea>
                            @error('notes')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="ktp_file" class="block text-sm font-medium text-gray-700 mb-2">Upload KTP
                                *</label>
                            <input type="file" id="ktp_file" name="ktp_file" required accept="image/*,.pdf"
                                class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            <p class="text-sm text-gray-500 mt-1">No file chosen</p>
                            @error('ktp_file')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <button type="submit"
                            class="w-full bg-[#8B8B8B] text-white py-3 px-6 rounded-none font-semibold hover:bg-gray-400 transition duration-150">
                            Registrasi
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
